unit GraphUnDoTools;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, Dialogs, ExtCtrls;

//   :     
type TQItem = class(TObject)
 protected
   fPNext    : pointer;  //    
   fPPred    : pointer;  //    
   fSRect    : TRect;    //   
   fSBitMap  : TBitMap;  //   
   // 
   procedure SetSRect(RqSRect : TRect);
   procedure SetSBitMap(RqSBitMap  : TBitMap);
 public
   // 
   property PNext   : pointer read fPNext;
   property PPred   : pointer read fPPred;
   property SRect   : TRect   read fSRect write SetSRect;
   property SBitMap : TBitMap read fSBitMap write SetSBitMap;
end;

//   :       
type TIQueue = class(TQItem)
 protected
   fMaxCount : integer;     //   
   fPHead    : TQItem;      //    
   fPTail    : TQItem;      //    
   fICount   : integer;     //    
   fPBuf     : TQItem;      //    
   procedure SetMaxCount(aMaxCount : integer);
 public
   constructor Create();
   procedure Free();
   procedure ClearQueue();
   procedure DeleteItemFromHead();
   procedure DeleteItemFromTail();
   procedure AddItemToTail(RqBitMap : TBitMap; RqRect : TRect);
   procedure ShowQueueTo(RqControl : TControl); virtual;
   property  MaxCount : integer read fMaxCount write SetMaxCount;
end;

//   :  UnDo 
type TGraphUnDo = class(TIQueue)
 protected
   fEnabled  : boolean;      //    UnDo
   fRect     : TRect;        //    fBitMap
   fBitmap   : TBitmap;      //    BitMap
 private
   procedure SetEnabled(RqEnabled : boolean);
 public
   constructor Create();
   //    UnDo
   procedure ClearUnDo();
   //   (RqRect)  (RqImage)   UnDo
   procedure SaveUnDoBitMap(RqImage : TImage; RqRect : TRect); virtual;
   //   (RqRect)  (RqImage)   UnDo
   procedure RestoreUnDoBitMap(RqImage : TImage); virtual;
   //      
   property  UnDoCount : integer read fICount;
   //    UnDo
   property  Enabled   : boolean read fEnabled write SetEnabled;
end;

implementation

// -----------------------------------------------------------------------
//   TQItem
// -----------------------------------------------------------------------
procedure TQItem.SetSRect(RqSRect : TRect);
begin fSRect := RqSRect; end;

procedure TQItem.SetSBitMap(RqSBitMap : TBitMap);
begin fSBitMap := RqSBitMap; end;

// -----------------------------------------------------------------------
//     TIQueue
// -----------------------------------------------------------------------
// 
constructor TIQueue.Create ();
begin
  inherited Create;
  fMaxCount := 8;               //     
end;

// 
procedure TIQueue.Free();
begin
  ClearQueue();                //   
  inherited Free;              //   
end;

//         
procedure TIQueue.DeleteItemFromHead();
begin
 if (fICount > 0) and Assigned(fPHead)
 then begin
 //   
   fPBuf  := fPHead;           //  fPBuf  
   fPHead := fPBuf.PNext;      //     
   if Assigned(fPHead)
   then begin
      fPHead.fPPred := nil;    //    
      fICount := fICount - 1;  //    
   end
   else begin
      //     
      fPHead    := nil;        //    
      fPTail    := nil;        //    
      fICount := 0;            //    
   end;
   if Assigned(fPBuf.fSBitMap)
   then fPBuf.fSBitMap.Free;   //  BitMap  
   fPBuf.Free;                 //   
   fPBuf := nil;               //   
 end;
end;

//         
procedure TIQueue.DeleteItemFromTail();
begin
 if (fICount > 0) and Assigned(fPTail)
 then begin
   //   
   fPBuf  := fPTail;           //     
   fPTail := fPBuf.fPPred;     //     
   if Assigned(fPTail)
   then begin
      fPTail.fPNext := nil;    //    
      fICount := fICount - 1;  //    
   end
   else begin
      //     
      fPHead    := nil;        //    
      fPTail    := nil;        //    
      fICount := 0;            //    
   end;
   if Assigned(fPBuf.fSBitMap)
   then fPBuf.fSBitMap.Free;   //  BitMap  
   fPBuf.Free;                 //   
   fPBuf := nil;               //   
 end;
end;

//      
procedure TIQueue.AddItemToTail(RqBitMap : TBitMap; RqRect : TRect);
begin
   if Assigned(fPTail)             //    
   then begin
      //    (   )
      fPBuf  := TQItem.Create;     //    
      fPBuf.fPNext  := nil;        //    
      fPTail.fPNext := fPBuf;      //     
      fPBuf.fPPred  := fPTail;     //     
      fPTail:= fPBuf;              //    
      fICount := fICount + 1;      //   
   end
   else begin
      //   (    )
      fPBuf  := TQItem.Create;     //    
      fPBuf.fPNext  := nil;        //    
      fPBuf.fPPred  := nil;        //    
      fPHead := fPBuf;             //    
      fPTail := fPBuf;             //    
      fICount := 1;                //    
   end;
   fPBuf.fSRect  := RqRect;        //    
   fPBuf.fSBitMap := RqBitMap;
   //          
   if (fICount > MaxCount)
   then DeleteItemFromHead();
end;

//   
procedure TIQueue.ClearQueue();
begin
  //    
  while (fICount > 0) and Assigned(fPHead) and Assigned(fPTail)
  do DeleteItemFromHead();
end;

//   MaxCount
procedure TIQueue.SetMaxCount(aMaxCount : integer);
begin
  if aMaxCount < fICount
  then begin
     ClearQueue();              //   
     fMaxCount := aMaxCount;    //     
  end
  else fMaxCount := aMaxCount;  //     
end;

//      RqControl ()
procedure TIQueue.ShowQueueTo(RqControl : TControl);
begin
 //  
 MessageDlg('.   : ' + IntToStr(fICount)
          + #13
          + '   : ' + IntToStr(fICount),
            mtInformation, [mbOk], 0);
end;

// -----------------------------------------------------------------------
//     TGraphUnDo
// -----------------------------------------------------------------------
// 
constructor TGraphUnDo.Create ();
begin
  inherited Create;
  fEnabled  := True;      //   UnDo
end;

//   Enabled
procedure TGraphUnDo.SetEnabled(RqEnabled : boolean);
begin
   if fEnabled <> RqEnabled
   then begin
      ClearQueue();
     fEnabled := RqEnabled;
   end;
end;

//   (RqRect)  (RqImage)   UnDo
procedure TGraphUnDo.SaveUnDoBitMap(RqImage : TImage; RqRect : TRect);
begin
  if fEnabled and Assigned(RqImage)
  then begin
     //   Bitmap
     fRect := Rect(0,0, Abs(RqRect.Right  - RqRect.Left),
                        Abs(RqRect.Bottom - RqRect.Top));
     try
        //  Bitmap    
        fBitmap := TBitmap.Create;
        fBitmap.Width  := fRect.Right  - fRect.Left;
        fBitmap.Height := fRect.Bottom - fRect.Top;
        //     Bitmap
        fBitmap.Canvas.CopyRect(fRect, RqImage.Canvas, RqRect);
        //   Bitmap    (  )
        AddItemToTail(fBitmap, RqRect);
     except
     //   UnDo
     SetEnabled(False);
     MessageDlg('     UnDo.'
              + #13
              + '  UnDo  !',
              mtError, [mbOk], 0);
     end;
  end;
end;

//   (RqRect)  (RqImage)   UnDo
procedure TGraphUnDo.RestoreUnDoBitMap(RqImage : TImage);
begin
  if fEnabled and Assigned(RqImage)
  then begin
     if (fICount > 0) and Assigned(fPTail)
     then begin
       fBitMap := fPTail.fSBitMap;
       fRect   := fPTail.SRect;
       //  BitMap  RqImage
       RqImage.Canvas.Draw(fRect.Left, fRect.Top, fBitMap);
       //      (  )
       DeleteItemFromTail();
     end;
  end;
end;

//    UnDo
procedure TGraphUnDo.ClearUnDo();
begin
  ClearQueue();
end;


end.
